IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_COSMOS_CARGA_ESTOQUE]'))
DROP VIEW [dbo].V_COSMOS_CARGA_ESTOQUE
GO

CREATE VIEW V_COSMOS_CARGA_ESTOQUE
AS 

SELECT
    EPC.CD_FILIAL                    AS ID_FILIAL,
	PRCFIL.CGC						 AS CNPJ_FILIAL,
    EPCB.CD_BARRA                    AS EAN,
    EP.DS_PROD                       AS DESCRICAO_PRODUTO,
    EPC.QT_EST                       AS QUANTIDADE,
    EPP.VLR_TABELA                   AS PRECO,
    EPP.VLR_OFERTA                   AS PRECO_PROMOCAO

FROM 
    EST_PROD_CPL EPC
    INNER JOIN EST_PROD EP ON (
        EP.CD_PROD           = EPC.CD_PROD
        AND EP.CD_EMP        = EPC.CD_EMP
    )
    INNER JOIN PRC_FILIAL PRCFIL ON (
        PRCFIL.CD_EMP        = EPC.CD_EMP
        AND PRCFIL.CD_FILIAL    = EPC.CD_FILIAL
    )
    LEFT JOIN EST_PROD_CD_BARRA EPCB ON (
        EPCB.CD_PROD    = EPC.CD_PROD
        AND EPCB.CD_EMP = EPC.CD_EMP
    )
	LEFT JOIN EST_PROD_PRECO EPP ON (
        EPP.CD_EMP			= EPC.CD_EMP
        AND EPP.CD_FILIAL   = EPC.CD_FILIAL
        AND EPP.CD_PROD     = EPC.CD_PROD
    )   
